function [Fx, Fy] = pressureForce(p, th, b, r)
%UNTITLED2 Summary of this function goes here
% th: vettore RIGA che contiene le porzioni angolari a cui associo un valore di
% pressione notevole --> lo definisco da 0 a 2*pi (in rad)
% p  [Pa]: vettore RIGA che contiene le pressioni delle porzioni angolari, stessa
% lunghezza di vettore th
% b, r  [mm] : raggio e spessore degli archi di circonferenza
b = b*0.001; %conversione [mm] -> [m]
r = r*0.001;  %conversione [mm] -> [m]
f = 2*p.*sin(th/2)*b*r;
phi = zeros(1, length(th));
phi(1) = th(1)/2;
for ii = 2 : length(th)
    phi(ii) = phi(ii-1) + th(ii-1)/2 + th(ii)/2;
end

fx = -f.*cos(phi); fy = -f.*sin(phi);
Fx = sum(fx); Fy = sum(fy);

end

